/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.event.CustomGuiEvent;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.util.CustomNPCsScheduler;

public class CustomGuiController {
    static boolean checkGui(CustomGuiEvent event) {
        Object player = event.player.getMCEntity();
        return ((EntityPlayer)player).field_71070_bA instanceof ContainerCustomGui && ((ContainerCustomGui)((EntityPlayer)player).field_71070_bA).customGui.getId() == event.gui.getId();
    }

    public static CustomGuiWrapper getOpenGui(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerCustomGui) {
            return ((ContainerCustomGui)player.field_71070_bA).customGui;
        }
        return null;
    }

    public static void onButton(CustomGuiEvent.ButtonEvent event) {
        Object player = event.player.getMCEntity();
        CustomGuiWrapper gui = CustomGuiController.getOpenGui(player);
        if (CustomGuiController.checkGui(event) && gui != null && gui.getScriptHandler() != null) {
            gui.getScriptHandler().run(EnumScriptType.CUSTOM_GUI_BUTTON.function, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onClose(CustomGuiEvent.CloseEvent event) {
        Object player = event.player.getMCEntity();
        CustomGuiWrapper gui = CustomGuiController.getOpenGui(player);
        if (CustomGuiController.checkGui(event) && gui != null && gui.getScriptHandler() != null) {
            gui.getScriptHandler().run(EnumScriptType.CUSTOM_GUI_CLOSED.function, event);
            event.player.closeGui();
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onScrollClick(CustomGuiEvent.ScrollEvent event) {
        Object player = event.player.getMCEntity();
        CustomGuiWrapper gui = CustomGuiController.getOpenGui(player);
        if (CustomGuiController.checkGui(event) && gui != null && gui.getScriptHandler() != null) {
            gui.getScriptHandler().run(EnumScriptType.CUSTOM_GUI_SCROLL.function, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onSlotChange(CustomGuiEvent.SlotEvent event) {
        Object player = event.player.getMCEntity();
        CustomGuiWrapper gui = CustomGuiController.getOpenGui(player);
        if (CustomGuiController.checkGui(event) && gui != null && gui.getScriptHandler() != null) {
            gui.getScriptHandler().run(EnumScriptType.CUSTOM_GUI_SLOT.function, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static boolean onSlotClick(CustomGuiEvent.SlotClickEvent event) {
        Object player = event.player.getMCEntity();
        CustomGuiWrapper gui = CustomGuiController.getOpenGui(player);
        if (CustomGuiController.checkGui(event) && gui != null && gui.getScriptHandler() != null) {
            gui.getScriptHandler().run(EnumScriptType.CUSTOM_GUI_SLOT_CLICKED.function, event);
        }
        return WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void openGui(PlayerWrapper<?> player, CustomGuiWrapper gui) {
        EntityPlayerMP pl = (EntityPlayerMP)player.getMCEntity();
        gui.setPlayer(pl);
        pl.openGui((Object)CustomNpcs.instance, EnumGuiType.CustomGui.ordinal(), pl.field_70170_p, gui.getSlots().length, 0, 0);
        CustomNPCsScheduler.runTack(() -> Server.sendDataChecked(pl, EnumPacketClient.GUI_DATA, gui.toNBT()));
        ((ContainerCustomGui)pl.field_71070_bA).setGui(gui, (EntityPlayer)pl);
    }

    public static String[] readScrollSelection(ByteBuf buffer) {
        try {
            NBTTagList list = Server.readNBT(buffer).func_150295_c("selection", 8);
            String[] selection = new String[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                selection[i] = ((NBTTagString)list.func_179238_g(i)).func_150285_a_();
            }
            return selection;
        }
        catch (IOException e) {
            LogWriter.error(e);
            return null;
        }
    }

    public static void updateGui(PlayerWrapper<?> player, CustomGuiWrapper gui) {
        EntityPlayerMP pl = (EntityPlayerMP)player.getMCEntity();
        if (!(pl.field_71070_bA instanceof ContainerCustomGui)) {
            return;
        }
        CustomNPCsScheduler.runTack(() -> Server.sendDataChecked(pl, EnumPacketClient.GUI_DATA, gui.toNBT()));
    }
}

